﻿/// <reference name="MicrosoftAjax.js"/>
NumberOnlyTextBox = function(element) {
  NumberOnlyTextBox.initializeBase(this, [element]);
  this._keyDownDelegate = null;
};

NumberOnlyTextBox.prototype = {
  initialize: function() {
    NumberOnlyTextBox.callBaseMethod(this,'initialize');
    this._keyDownDelegate = Function.createDelegate(this, this._keyDownHandler);
    $addHandler(this.get_element(), "keydown", this._keyDownDelegate);
  },
  
  dispose: function() {
    $removeHandler(this.get_element(), "keydown", this._keyDownDelegate);
    this._keyDownDelegate = null;
    NumberOnlyTextBox.callBaseMethod(this, 'dispose');
  },
  
  _keyDownHandler: function(e) {
     return ((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode == 8));
  }
};

NumberOnlyTextBox.registerClass("NumberOnlyTextBox", Sys.UI.Behavior);